#!/usr/bin/perl



use CGI qw(:standard);
use CGI::Cookie;
use Digest::MD5 qw(md5 md5_hex md5_base64);

print "Content-type: text/html\n";

use vars qw(%pages, %auth, %allowed, %meta);
my $current = param('page');
my $configfile = 'conf/cms.conf';
my $action;
my $uid;
my $password;
my $logincookie;
my $cookie;
my $allowedpages;
my $SID;

unless(do $configfile) {
	print "\nInvalid Configuration $configfile, $!";
	die;
}



login();
display_interface();

sub login()
{
	$action = param('submissiontype');
	$uid = param('uid');
	$password = param('password');


	if ($action eq "login") {
		
		unless($auth{$uid} eq  md5_hex($password)) {
			die("invalid password request with $password");
		}
		
		#set cookie
		$SID = set_sid(remote_host());
		$cookie = new CGI::Cookie( -name  =>  'intranet',
		-value =>  $SID,
		
		);

	} elsif ($action eq "log out") {

		#write junk to cookie
		$cookie = new CGI::Cookie( -name =>   'intranet',
		-value =>  kill_sid(remote_host()),
		);

	} else {

		#get uid and password from cookie
		my %cookies = fetch CGI::Cookie;
		$logincookie = $cookies{'intranet'};
		$SID = $logincookie->value;
		
	}

	print "Set-Cookie: $cookie\n\n";

	unless(verify_session(remote_host(), $SID) eq 'true') {

		print <<"end_redirect";
		Content-type: text/html


		<html>
		<head>
		<meta HTTP-EQUIV="REFRESH" content="1; url=http://ketteringdeltachi.org/asection/">   
		<title>Login Failed</title>
		</head>
		<body>
		<h1>Invalid Login, Redirecting...</h1>

		</body>
		</html>

end_redirect


		die("invalid login failure, script problem $!");

	}


	if($action eq 'Save') {
		my $pagetext = param('message');
		my $page = param('file');
		open(SAVE, ">$page.$uid") or die("cannot open $page.$uid, $!");
		print SAVE $pagetext;
		close(SAVE);
		
		
	} elsif($action eq 'Revert') {
		open(LOG, ">>log.txt");
		my $page = param('file');
		print LOG "reverting file $page...\n";
		if(-e $page.".$uid") {unlink($page.".$uid"); print LOG "revert sucessful\n";}
		$current = $page;
		close(LOG);
		
	 } elsif($action eq 'Refactor') {
	 
	 
	 if(fork() == 0) {
      do('cms.cgi');
	 }
		
	} elsif($action eq 'Commit') {
	
	
		my @failed;
		open(LOG, ">>log.txt");
		print LOG "attempting to commit\n";
		open(USERLOCK, "$uid.lock");
		my $flag;
		foreach(<USERLOCK>) {
			$flag = 0;
			chomp($_);
			open(SOURCELOCK, "$_.lock");
			@locking_users = <SOURCELOCK>;
			close(SOURCELOCK);
			open(SOURCELOCK, ">$_.lock");
				print LOG "examining lock on: $_...\n";
				
			foreach(@locking_users) {
				chomp($_);
				print LOG "   locked by: $_ compared to $uid\n";
				if($_ ne $uid && $_ ne ""){print SOURCELOCK $_; $flag = 1; print LOG "wtf? $_\n";}
			}
			close(SOURCELOCK);
			if($flag == 0) {
				unlink("$_.lock");
				if(-e "$_.$uid") {
					unlink($_);
					rename($_.".".$uid, $_);
				}
				print LOG "  file $_.lock deleted \n   file $_ deleted \n   file $_.$uid renamed $_ \n";
			} else {
				unshift(@failed, $_);
			}
		}
		open(USERLOCK, ">$uid.lock");
		foreach(@failed) {
			print USERLOCK $_."\n";
			print LOG $_." failed to commit\n";
		}
		
		close(LOG);
	}
}



sub verify_session
{
	my $ip = $_[0];
	my $sid = $_[1];
	my $flag = false;
	open (SID, "sessions.id") or die("$ip, $sid, error $_");
	foreach(<SID>) {
		chomp($_);
		$_ =~ /(.+),(.+),(.+)/;
		#die("$1, $ip, $2, $sid");
		if($1 eq $ip && $2 eq $sid) {
			$uid = $3;
			$flag = 'true';
			#die($_);
		}
	}

	return $flag;
}

sub set_sid
{
#read in all sessions
#kill all sessions with current IP address
#return sid
	my $newsid = ((rand(998)+1)*(rand(998)+1));
	my $ip = $_[0];
	my $sidline = "$ip,$newsid,$uid\n"; 

	kill_sid($ip);

	open (SID, ">>sessions.id");


	print SID $sidline;
	return $newsid;

}



sub kill_sid
{
	my $ip = $_[0];
	my %sids;
	my $killid;

	open (SID, "sessions.id");
	foreach(<SID>) {
		chomp($_);
		$_ =~ /(.+),(.+),(.+)/;
		$sids{$1} = "$2,$3";
	}
	close(SID);

	open(SID, ">sessions.id");

	while (my ($key, $value) = each(%sids)) {
		if($key ne $ip) {
			print SID "$key,$value\n";
		}
	}
	close(SID);
}



################################################################################
## sub display_interface()
## displays the correct interface based on the last several action
##
## kinda complicated, the js is embedded in the html which is imbedded in the perl...
## its like a wierd call stack... yay for web servers...
##
##
##
##
##
##
##
##

sub display_interface()
{
	my $currversion;
	if(-e "$current.$uid"){$currversion = "$current.$uid";}
	else {$currversion = $current;}
	
	print <<"_end_of_part1_";



	<html>
	<head>
	<title>Web Editor</title>
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">

	<SCRIPT language=JavaScript>


	function go()
	{
		box = document.forms[0].filelist;
		destination = "editor.cgi?page=" + box.options[box.selectedIndex].value;
		if (destination) location.href = destination;

	}

	function gometa()
	{
		box = document.forms[0].metalist;
		destination = "editor.cgi?page=" + box.options[box.selectedIndex].value;
		if (destination) location.href = destination;

	}


	</script>

	</head>
	<body>

	<form name="admin" method="post" action="editor.cgi">
	<p align="right">
	Logged in as $uid
	<input type="submit" name="submissiontype" value="log out"><br><a href="calupdate.cgi">Update Calendar</a>
	<br><h1>$current</h1>
	</p>

	<table><tr><td>
Pages:<br>
	<select name="filelist" size="20" onChange="go()">

_end_of_part1_


#######
#######
####### back to perl
#######
#######




	if($allowed{$uid} eq 'ALL') {
		while (my ($key, $value) = each(%pages)) {
			print "<option value=\"source/@{$pages{$key}}[0]\">@{$pages{$key}}[0]</option>";
		}
		print "</select><br>Meta:<br><select name=\"metalist\" size=\"5\" onChange=\"gometa()\">";

		while (my ($key, $value) = each(%meta)) {
			print "<option value=\"$value\">$key</option>";
		}
	} else {
		foreach(@{$allowed{$uid}}) {
			print "<option value=\"$_\">$_</option>";
		}
	}

	print "</select><br>
<input type=\"submit\" name=\"submissiontype\" value=\"Save\"> (saves changes to this file)<br>
<input type=\"submit\" name=\"submissiontype\" value=\"Revert\"> (destroys all changes and reloads file)<br>
<input type=\"submit\" name=\"submissiontype\" value=\"Refactor\"> (run plugins and apply all changes to website)<br>
<input type=\"hidden\" name=\"file\" value=\"$current\"></td><td><br><textarea name=\"message\" rows=40 cols=100>";

	if(get_lock_for_current_user($current) == 1) {
		open(EDIT, "$currversion");
		foreach(<EDIT>) {print $_;}
	} else {
		print "unable to get file lock on $current.  You may not be allowed to edit this file or SimpCMS may have created and error.\n\n";
	}

	print '</textarea></td></tr></table>';

	open(LOCKED, "$uid.lock");
	print "<ul>\n";
	my $i = 0;
	foreach(<LOCKED>) {
		print "<li>$_</li>\n";
		$i++;
	}
	print "</ul>\n"."<input type=\"submit\" name=\"submissiontype\" value=\"Commit\"></form></body></html>";
	close(LOCKED);
}

sub get_lock_for_current_user() {
	my $view_perm = 0;
	my $file = shift(@_);
	
	foreach(@{$allowed{$uid}}) {
		print $_."     ".$file;
		if($_ eq $file) {$view_perm = 1;}
	}
	
	if($allowed{$uid} eq 'ALL') {$view_perm = 1;}
	if($current eq "")          {$view_perm = 1;}
	
	
	if($view_perm != 1) {
		return 0;
	} else {
		if($file ne "") {
			if(-e "$file.lock") {
				my $flag = 0;
				open(LOCK, "$file.lock");
				foreach(<LOCK>) {
					chomp($_);
					if($uid == $_) {$flag = 1;}
				}
				close(LOCK);
				if($flag) {
					open(LOCK, ">$file.lock");
					print LOCK $uid."\n";
					close(LOCK);
				}
			} else {
				open(LOCK, ">$file.lock");
				print LOCK $uid."\n";
				close(LOCK);
				open(LOCK, ">>$uid.lock");
				print LOCK $file."\n";
				close LOCK;
			}
		}	
	}
	return 1;
}
#--/>
