<?php
// gpa.php
//
// feed input to converter and display results
//
// By: Krunal Desai
// 2008-10-28
//
include("gpaConv.inc");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
	<head>
		<title>WGA to GPA Conversion - Results</title>
		<style type="text/css">
			@import url("gpaConv.css");
		</style>
	</head>
	<body>
		<h1 class="header">Results</h1>
		<?php

			$startTime = microtime_float();

			$input = $_POST['input'];
			$j = explode("\n", $input);

			$grades = array();

			convertGPA($j);

			$endTime = microtime_float();
		?>

		<h3 class="header">Method</h3>
		<table>
			<tr>
				<td>
					<ul>
						<li class="standard">Each course WGA converted to GPA based on scale to the right.</li>
						<li class="standard">Resultant GPA multiplied by number of credits course is worth.</li>
						<li class="standard">All GPAs summed and divided by number of earned credits.</li>
						<li class="standard">The conversion table cannot be used to <strong>directly</strong> translate a CWGA to a CGPA.</li>
						<li class="standard">Only applies to credits <strong>earned</strong> at Kettering. Courses marked <strong>CR</strong> are ignored.</li>
						<li class="standard">This conversion is only intended to be used as an aid to get a general idea of what your WGA would be converted, and should not be treated as official.</li>
						<li class="standard"><strong>NOT</strong> endorsed by Kettering in any way, shape, or form. :)</li>
					</ul>
				</td>
				<td>
					<table id="gpaTable">
						<caption class="standard">GPA Conversion Table (2008-10-22)</caption>
						<thead>
							<tr>
								<th scope="col">Letter Grade</th>
								<th scope="col">Points</th>
								<th scope="col">Equivalent WGA</th>
							</tr>
						</thead>
						<tbody>
					  	<tr class="a">
						    <td>A</td>
						    <td>4.0</td>
						    <td>93-100</td>
					  	</tr>
					  	<tr class="a">
						    <td>A-</td>
						    <td>3.7</td>
						    <td>89-92</td>
					  	</tr>
							<tr class="b">
						    <td>B+</td>
						    <td>3.3</td>
						    <td>86-88</td>
					  	</tr>
						  <tr class="b">
						    <td>B</td>
						    <td>3.0</td>
						    <td>81-85</td>
						  </tr>
						  <tr class="b">
						    <td>B-</td>
						    <td>2.7</td>
						    <td>78-80</td>
						  </tr>
						  <tr class="c">
						    <td>C+</td>
						    <td>2.3</td>
						    <td>76-77</td>
						  </tr>
						  <tr class="c">
						    <td>C</td>
						    <td>2.0</td>
						    <td>74-75</td>
						  </tr>
						  <tr class="c">
						    <td>C-</td>
						    <td>1.7</td>
						    <td>72-73</td>
						  </tr>
						  <tr class="d">
						    <td>D+</td>
						    <td>1.3</td>
						    <td>71</td>
						  </tr>
						  <tr class="d">
						    <td>D</td>
						    <td>1.0</td>
						    <td>70</td>
						  </tr>
						  <tr class="f">
						    <td>F</td>
						    <td>0.0</td>
						    <td>65</td>
						  </tr>
						</tbody>
					</table>
				</td>
			</tr>
		</table>		
		<hr />
		<?php
			printVersion($startTime, $endTime);
		?>
		</body>
</html>