<?php
// gpaConv.inc
//
// Functions to convert WGA to GPA from transcript
//
// By: Krunal Desai
// 2008-10-28
// 

define("_VERSION", "v. 1.4.2 - 20081102");

function microtime_float()
{
    list($utime, $time) = explode(" ", microtime());
    return ((float)$utime + (float)$time);
}

function printVersion($startTime, $endTime)
{	
	echo nl2br(sprintf("<p class=\"footer\">"));
	if ($startTime || $endTime)
	{
		echo nl2br(sprintf("Script Executed in %01.4F seconds - PHP " . phpversion() . "\n", ($endTime - $startTime)));		
	}	
	
	echo nl2br("XHTML 1.0 Strict Validated - w3c.org\n");
	echo nl2br(_VERSION . "</p>");
}

function getGPA($wga)
{
	if ($wga >= 93)
		return 4.0;
	
	else if ($wga >= 89 && $wga <= 92)
		return 3.7;
		
	else if ($wga >= 86 && $wga <= 88)
		return 3.3;
	
	else if ($wga >= 81 && $wga <= 85)
		return 3.0;
		
	else if ($wga >= 78 && $wga <= 80)
		return 2.7;
		
	else if ($wga >= 76 && $wga <= 77)
		return 2.3;
		
	else if ($wga >= 74 && $wga <= 75)
		return 2.0;
		
	else if ($wga >= 72 && $wga <= 73)
		return 1.7;
		
	else if ($wga === 71)
		return 1.3;
		
	else if ($wga === 70)
		return 1.0;
	
	else
		return 0.0;
}	

function getGradeColor($wga)
{
	if ($wga >= 93)
		return "<span class=\"result\" style=\"color:#009900\">";		
	
	else if ($wga >= 89 && $wga <= 92)
		return "<span class=\"result\" style=\"color:#009900\">";		
		
	else if ($wga >= 86 && $wga <= 88)
		return "<span class=\"result\" style=\"color:#999900\">";		
	
	else if ($wga >= 81 && $wga <= 85)
		return "<span class=\"result\" style=\"color:#999900\">";		
		
	else if ($wga >= 78 && $wga <= 80)
		return "<span class=\"result\" style=\"color:#999900\">";		
		
	else if ($wga >= 76 && $wga <= 77)
		return "<span class=\"result\" style=\"color:#CC9900\">";		
		
	else if ($wga >= 74 && $wga <= 75)
		return "<span class=\"result\" style=\"color:#CC9900\">";		
		
	else if ($wga >= 72 && $wga <= 73)
		return "<span class=\"result\" style=\"color:#CC9900\">";		
		
	else if ($wga === 71)
		return "<span class=\"result\" style=\"color:#FF9900\">";		
		
	else if ($wga === 70)
		return "<span class=\"result\" style=\"color:#FF9900\">";		
	
	else
		return "<span class=\"result\" style=\"color:#FF3300\">";		
}

function parseQP($t, $a)
{
	$i = 2;
	while (1)
	{
		if (preg_match("/[0-9]/", $t[$a + $i]))
		{									
			$intQp = substr(trim($t[$a+$i]), 0, 1);
			break;
		}		
		$i++;	
	}
	
	return $intQp;
}

function convertGPA($arr)
{		
	$grades = array();	
	
	$numGrades = 0;
	$numCredits = 0;
	$totalGPA = 0.0;
	$totalQP = 0.0;		
	$wgaFound = false;
	
	foreach($arr as $str)
	{
		$t = explode(" ", $str);
		$a = 0;
		
		while ($a < count($t))
		{		
			$t_ = trim($t[$a]);			
			if (strlen($t_))
			{
				if (preg_match("/[0-9]\.[0-9][0-9]/", $t_)) // xx.xx
				{				
					if (strlen($t[$a+1]))
					{					
						if (preg_match("/^[0-9]/", $t[$a+1])) // numeric
						{
							$credits = $t[$a];
							$wga = $t[$a+1];
							
							$qp = $wga * $credits;
							$gpa = getGPA($wga);
							$wgpa = $gpa * $credits;							
							/*
							echo nl2br("\r\nCourse $numGrades\r\n");													
							echo nl2br(sprintf("\r\nCREDITS: %01.2F\r\n", $credits));
							echo nl2br(sprintf("WGA: %d\r\n", $wga));						
							echo nl2br(sprintf("QUALITY POINTS: %01.2F\r\n", $qp));
							echo nl2br(sprintf("GPA: %01.2F\r\n", $gpa));
							echo nl2br(sprintf("WGPA: %01.2F\r\n", $wgpa));
							*/																		
							//array_push($grades, $wgpa);						
							
							
							if (parseQP($t, $a))
							{												
								$numCredits += $credits;
								$totalGPA += $wgpa;
								$totalQP += $qp;
								$numGrades++;
							}
						}
					}		
				}			
			}
			
			$a++;
		}
		
		unset($t_);		
	}
	
	if (!$numCredits)
		$numCredits = 1;
	
	$cgpa = ($totalGPA / $numCredits);
	$cwga = ($totalQP / $numCredits);
	$colorString = getGradeColor($cwga);
	
	echo sprintf("<p class=\"standard\">\n");
	echo nl2br(sprintf("%d courses found, total credits: %01.2F\r\n", $numGrades, $numCredits));
	echo nl2br(sprintf("Cumulative WGA: %s%01.3F</span> (%01.2F Quality Points / %01.2F Quality Points)\n", $colorString, $cwga, $totalQP, $numCredits * 100));
	echo nl2br(sprintf("Cumulative GPA: %s%01.4F</span> (%01.2F Grade Points / %01.2F Credits Earned)\n", $colorString, $cgpa, $totalGPA, $numCredits));	
	echo sprintf("</p>\n");
}	
?>