<?php
	include("gpaConv.inc");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
	<head>
		<title>WGA to GPA Conversion</title>
		<style type="text/css">
			@import url("gpaConv.css");			
		</style>
	</head>
	<body>
		<h1 class="header">WGA to GPA Converter</h1>
		<p class="standard">Converts WGA to GPA based on the new Kettering GPA conversion system found on Blackboard.</p>		
		<h2 class="header">How to Use</h2>
		<ol>
			<li class="standard">Login to Bannerweb, generate an unofficial, <strong>100 point scale</strong> transcript.</li>
			<li class="standard">Select-All (Ctrl+A) the generated transcript, and paste it into the textbox below.</li>
			<li class="standard">Hit <strong>Submit</strong>.</li>
		</ol>
		<p class="standard">None of the transcript data is saved on server - it's just used and then dumped immediately. No worries!</p>
		<table>
			<tbody>			
				<tr>
					<td>						
						<p class="standard">Paste Here:</p>
						<form action = "gpa.php" method = "post">
							<p class="standard">
							<textarea name="input" cols="70" rows="20"></textarea>
							<input type="submit" value="Submit"/>
							</p>
						</form>
					</td>
					<td>						
						<table id="gpaTable">
							<caption class="standard">GPA Conversion Table (2008-10-22)</caption>
							<thead>
								<tr>
									<th scope="col">Letter Grade</th>
									<th scope="col">Points</th>
									<th scope="col">Equivalent WGA</th>
								</tr>
							</thead>
							<tbody>
						  	<tr class="a">
							    <td>A</td>
							    <td>4.0</td>
							    <td>93-100</td>
						  	</tr>
						  	<tr class="a">
							    <td>A-</td>
							    <td>3.7</td>
							    <td>89-92</td>
						  	</tr>
								<tr class="b">
							    <td>B+</td>
							    <td>3.3</td>
							    <td>86-88</td>
						  	</tr>
							  <tr class="b">
							    <td>B</td>
							    <td>3.0</td>
							    <td>81-85</td>
							  </tr>
							  <tr class="b">
							    <td>B-</td>
							    <td>2.7</td>
							    <td>78-80</td>
							  </tr>
							  <tr class="c">
							    <td>C+</td>
							    <td>2.3</td>
							    <td>76-77</td>
							  </tr>
							  <tr class="c">
							    <td>C</td>
							    <td>2.0</td>
							    <td>74-75</td>
							  </tr>
							  <tr class="c">
							    <td>C-</td>
							    <td>1.7</td>
							    <td>72-73</td>
							  </tr>
							  <tr class="d">
							    <td>D+</td>
							    <td>1.3</td>
							    <td>71</td>
							  </tr>
							  <tr class="d">
							    <td>D</td>
							    <td>1.0</td>
							    <td>70</td>
							  </tr>
							  <tr class="f">
							    <td>F</td>
							    <td>0.0</td>
							    <td>65</td>
							  </tr>
							</tbody>
						</table>
					</td>
				</tr>
			</tbody>
		</table>
				
		<h4 class="header">Notes</h4>
		<ul>
			<li class="standard">Should handle failures, withdrawals, audits, as well as retakes of classes (basically ignores anything with 0 quality points). If you have an issue, please e-mail me at desa8398@ku (you can cut out your name if you want).</li>
		</ul>		
		<h4 class="header">Extras</h4>
		<ul>
			<li class="standard">New! <a href="calendar.php">Convert</a> the proposed academic calendar to something that makes sense!</li>
		</ul>	
   	<hr />
		<?php
			printVersion(0, 0);
		?>
	</body>
</html>